#ifndef _STRING_CPP
#define _STRING_CPP
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#include <Windows.H>

#include "String.H"

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////

bool IsUpper(char cIn)
{
	return (cIn >= 65 && cIn <= 90);
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////

bool IsLower(char cIn)
{
	return (cIn >= 97 && cIn <= 122);
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////

char ToUpper(char cIn)
{
	if(IsLower(cIn))
	{
		return (cIn+32);
	}
	return cIn;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////

char ToLower(char cIn)
{
	if(IsUpper(cIn))
	{
		return (cIn-32);
	}
	return cIn;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////

char * UCaseEx (char *sBuf, int iBufSz)
{
	for(int iPos = 0; iPos < iBufSz; iPos++)
	{
		sBuf[iPos] = ToUpper(sBuf[iPos]);
	}
	return sBuf;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////

char * LCaseEx (char *sBuf, int iBufSz)
{
	for(int iPos = 0; iPos < iBufSz; iPos++)
	{
		sBuf[iPos] = ToLower(sBuf[iPos]);
	}
	return sBuf;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////

char * UCase (char *sBuf)
{
	
	return UCaseEx(sBuf, strlen(sBuf));
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////

char * LCase (char *sBuf)
{
	return LCaseEx(sBuf, strlen(sBuf));
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////

int ReplaceStrings(const char *sInBuf, const char *sReplace, const char *sWith, char *sOutBuf)
{
	const char *sNULL = NULL;

	int iReplaces = 0;

    int iReplaceLen = strlen(sReplace);

	if(sInBuf == NULL || sOutBuf == NULL)
	{
        return -1;
	}

    strcpy(sOutBuf, "");

	for(sNULL = sInBuf; *sNULL; ++sNULL)
	{
		if( strncmp(sNULL, sReplace, iReplaceLen ) == 0 )
		{
			strcat(sOutBuf, sWith);
			sNULL += (iReplaceLen - 1);
			iReplaces++;
		}
		else strncat(sOutBuf, sNULL, 1);
	}

	return iReplaces;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////

int ReplaceCharacter(const char *sInBuf, char *sOutBuf, const char cReplace, const char cWith)
{
	int iPos = 0;
	int iOccur = 0;
	int iLength = strlen(sInBuf);

	while(iPos < iLength)
	{
		if(sInBuf[iPos] != cReplace)
		{
			sOutBuf[iPos] = sInBuf[iPos];
			iOccur++;
		}
		else sOutBuf[iPos] = cWith;

		iPos++;
	}

	return iOccur;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////

bool ReverseString(char *sBuf, int iBufSz)
{
	char *String1 = NULL;
	char *String2 = NULL;

	if(!sBuf || !*sBuf)
	{
		return false;
	}

	for(String1 = sBuf, String2 = sBuf + iBufSz - 1; String2 > String1; ++String1, --String2)
	{
		*String1 ^= *String2;
		*String2 ^= *String1;
		*String1 ^= *String2;
	}

	return true;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////

int InStrExx(const char *sSearchFor, int sSearchForSz, const char *sInBuf, const int iBufSz, const int iStartPos)
{
	int iControlLoop  = 0; 
	int iLookingLoop  = 0; 
	int iStringStart  = -1;

	if(iStartPos > iBufSz)
	{
		return -2;
	}

	if(sSearchForSz > iBufSz)
	{
		return -2;
	}

	for(iControlLoop = iStartPos; iControlLoop <= (iBufSz-sSearchForSz); iControlLoop++)
	{
		if(sInBuf[iControlLoop] == sSearchFor[iLookingLoop])
		{
			while(iLookingLoop <= sSearchForSz) 
			{
				if(sSearchFor[iLookingLoop] == sInBuf[iLookingLoop + iControlLoop])
				{
					iLookingLoop++;
				}
				else iLookingLoop = sSearchForSz + 1; 

				if(iLookingLoop == sSearchForSz)
				{
					iStringStart = iControlLoop; 
					iControlLoop = (iBufSz - sSearchForSz) + 1;
				}
			}
		}
		iLookingLoop = 0;
	}

	return iStringStart; 
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////

int InStrEx(const char *sSearchFor, const char *sInBuf, const int iBufSz, const int iStartPos)
{
	return InStrExx(sSearchFor, strlen(sSearchFor), sInBuf, iBufSz, iStartPos);
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////

int InStr(const char *sSearchFor, const char *sInBuf)
{
	return InStrEx(sSearchFor, sInBuf, strlen(sInBuf), 0);
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////

bool CompareNCString(const char *sBuf1, const char *sBuf2)
{
	int iPos = 0;

	int Length1 = strlen(sBuf1);
	int Length2 = strlen(sBuf2);

	if(Length1 != Length2)
        return false;

	while(iPos < Length1 || iPos < Length2)
	{
		if(ToLower(sBuf1[iPos]) != ToLower(sBuf2[iPos]))
		{
            return false;
		}

		iPos++;
	}

	return true;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////

bool CompareCSString(const char *sBuf1, const char *sBuf2)
{
	int iPos = 0;
	int iLen = strlen(sBuf1);

	if(iLen != strlen(sBuf2))
	{
        return false;
	}

	while(iPos < iLen)
	{
		if(sBuf1[iPos] != sBuf1[iPos])
		{
            return false;
		}

		iPos++;
	}

	return true;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////

int StringScanEx(const char *sInBuf, int iStartPos, int iLength, char *sOutVal)
{
	strncpy(sOutVal, &sInBuf[iStartPos], iLength);
	return iLength;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////

// This functions return value must be freed externally
char *StringScan(const char *sInBuf, int iStartPos, int iLength)
{
	char *StringTemp = (char *) calloc(iLength + 1, 1);
	strncpy(StringTemp, &sInBuf[iStartPos], iLength);
	return StringTemp;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////

int AppendStrings(const char *sBuf1, const char *sBuf2, int iBuf1Sz, int iBuf2Sz, char *sOutBuf)
{
	int iWPos = iBuf1Sz;
	int iRPos = 0;

	memcpy(sOutBuf, sBuf1, iBuf1Sz);

	while(iRPos < iBuf2Sz)
	{
		sOutBuf[iWPos++] = sBuf2[iRPos++];
	}

	sOutBuf[iWPos] = '\0';

	return iWPos;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////

int CompareFlagedString(const char *sBuf, const char *sFlag)
{
	int iFlagLength = strlen(sFlag);

	if( strncmp(sBuf, sFlag, iFlagLength) == 0)
	{
		return iFlagLength;
	}

	return 0;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////

int GetFlagedValue(const char *sBuf, int iSkpLen, int iBufSz, char *sOutBuf)
{
	int iWPos = 0;
	int iRPos = iSkpLen;

	while(iRPos < iBufSz)
	{
		sOutBuf[iWPos++] = sBuf[iRPos++];
	}

	sOutBuf[iWPos] = '\0';

	return iWPos; //The length of the string returned in sOutBuf.
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////

char *SimpleCipherString(char *sBuf, int iBufSz)
{
	int iPos = 0;

	while(iPos < iBufSz)
	{
		sBuf[iPos] = (sBuf[iPos] + 128);
		iPos++;
	}

	return sBuf;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////

int CopyString(char *sOutBuf, const char *sInBuf, int iInBufSz)
{
    int iPos = 0;

    while(iPos < iInBufSz)
    {
        sOutBuf[iPos] = sInBuf[iPos];
        iPos++;
    }

    sOutBuf[iPos] = '\0';

    return iPos;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/*
	Returns a zero-based, one-dimensional array containing a specified number of substrings.

	Example:

		char **sArray = NULL;
		char *sBuf = "Hello\tCruel\tWorld\tFrom\tC\tPlus\tPlus\t";
		int iItems = 0;
		int iItem = 0;

		sArray = SplitEx(sBuf, strlen(sBuf), sArray, &iItems, strlen("\t"), 1);

		printf("Array Items: %d\n", UBound(sArray));

		while(iItem < iItems)
		{
			printf("Item[%d]: %s\n", iItem, sArray[iItem]);
			iItem++;
		}

		FreeSplitStringEx(sArray, iItems);
*/

char **SplitEx(char *sBuf, int iBufSz, char **sArray, int *iOutItems, char *sSplitOn, int iSplitOnSz)
{
	int iStartPos = 0;

	int iRPos = 0;
	int iWPos = 0;

	int iItems = 0;

	int iItemCount = 0; // The number of sub-strings that are going to be parsed from the string.
	int iLastPos = 0;

	//Get the number of items that we are going to split.
	while((iStartPos = InStrEx(sSplitOn, sBuf, iBufSz, iStartPos)) > 0)
	{
		iItemCount++;
		iStartPos = (iStartPos + iSplitOnSz);
		iLastPos = iStartPos;
	}

	//The string is not terminated by a delimiter.
	if(iBufSz > iLastPos)
	{
		iItemCount++;
	}

	iStartPos = 0;

	//Allocate enough RAM to hold all the sub-strings and the last NULL array item.
	sArray = (char **) calloc(sizeof(char *), iItemCount + 1);	

	while((iStartPos = InStrEx(sSplitOn, sBuf, iBufSz, iRPos)) > 0)
	{

		//Allocate enough RAM to hold the sub-string.
		sArray[iItems] = (char *) calloc(sizeof(char), (iStartPos - iRPos) + 1);

		iWPos = 0;
		while(iRPos < iStartPos)
		{
			sArray[iItems][iWPos++] = sBuf[iRPos++];
		}

		sArray[iItems][iWPos] = '\0';

		iRPos = (iRPos + iSplitOnSz);

		iItems++;
	}

	//The string is not terminated by a delimiter.
	if(iBufSz > iRPos)
	{
		//Allocate enough RAM to hold the sub-string.
		sArray[iItems] = (char *) calloc(sizeof(char), (iBufSz - iRPos) + 1);

		iWPos = 0;

		while(iRPos < iBufSz)
		{
			sArray[iItems][iWPos++] = sBuf[iRPos++];
		}

		sArray[iItems][iWPos] = '\0';
		iRPos = (iRPos + iSplitOnSz);

		iItems++;
	}
	
	//Insert a null at the end of the array.
	sArray[iItems] = NULL;

	*iOutItems = iItems;

	return sArray;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/*
	Returns a zero-based, one-dimensional array containing a specified number of substrings.

	Example:

		char **sArray = NULL;
		char *sBuf = "Hello\tCruel\tWorld\tFrom\tC\tPlus\tPlus\t";
		int iItem = 0;

		sArray = Split(sBuf, "\t");

		printf("Array Items: %d\n", UBound(sArray));

		while(sArray[iItem] != NULL)
		{
			printf("Item[%d]: %s\n", iItem, sArray[iItem]);
			iItem++;
		}

		FreeSplitString(sArray);
*/

char **Split(char *sBuf, char *sSplitOn)
{
	int iOutItems = 0;

	char **sArray = NULL;

	return SplitEx(sBuf, strlen(sBuf), sArray, &iOutItems, sSplitOn, strlen(sSplitOn));
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/*
	This function will free all the RAM allocated by an array.

	All array items, and the array its self.

	Intended for use with the Split() and SplitEx functions.
*/
void FreeArrayEx(char **sArray, int iItems)
{
	int iItem = 0;

	while(iItem < iItems)
	{
		free(sArray[iItem]);
		iItem++;
	}

	free(sArray);
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/*
	This function will free all the RAM allocated by an array.

	All array items, and the array its self.

	Intended for use with the Split() and SplitEx functions.
*/
void FreeArray(char **sArray)
{
	FreeArrayEx(sArray, UBound(sArray));
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/*
	This function will return the number of items in a char *Array[].
	This function will malfunction if the last item in the array is not NULL.

	Intended for use with the Split() and SplitEx functions.
*/
int UBound(char **sArray)
{
	int iItem = 0;

	while(sArray[iItem])
	{
		iItem++;
	}

	return iItem;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////

bool IsNumber(char cIn)
{
	return (cIn >= 48 && cIn <= 57);
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////

bool IsNumeric(char *sText)
{
	int iLen = strlen(sText);
	int iRPos = 0;

	if(iLen == 0)
	{
		return false;
	}

	while(iRPos < iLen)
	{
		if(!IsNumber(sText[iRPos]) && sText[iRPos] != '.')
		{
	        return false;
		}
		iRPos++;
	}

	return true;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////

int MidEx(const char *sInBuf, int iInBufSz, int iStartPos, int iRChars, char *sOutBuf)
{
	int iRPos = iStartPos;
	int iWPos = 0;
	int iChars = 0;

	if(iRChars <= 0 || iRChars > (iInBufSz - iStartPos) )
	{
		iChars = iInBufSz;
	}
	else iChars = (iStartPos + iRChars);

	while(iRPos < iChars)
	{
		sOutBuf[iWPos++] = sInBuf[iRPos++];
	}

	sOutBuf[iWPos] = '\0';

	return iWPos;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////

int StrCatEx(char *sOutBuf, const char *sInBuf, int iInBufSz, int iOutBufSz)
{
	int iRPos = 0;
	int iWPos = iOutBufSz;

	while(iRPos < iInBufSz)
	{
		sOutBuf[iWPos++] = sInBuf[iRPos++];
	}

	return iWPos;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////

int Right(const char *sInBuf, char *sOutBuf, int iInLen, int iRight)
{
	int iLen = iInLen;
	int iRPos = iLen - iRight;
	int iWPos = 0;

	if(iRight > iLen)
	{
		strcpy(sOutBuf, "");
		return 0;
	}

	while(iRPos < iLen)
	{
		sOutBuf[iWPos++] = sInBuf[iRPos++];
	}

	sOutBuf[iWPos] = '\0';

	return iWPos;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////

int Left(const char *sInBuf, char *sOutBuf, int iInLen, int iLeft)
{
	int iLen = iInLen;
	int iRPos = 0;

	if(iLeft > iInLen)
	{
		strcpy(sOutBuf, "");
		return 0;
	}

	while(iRPos < iLeft)
	{
		sOutBuf[iRPos] = sInBuf[iRPos];
		iRPos++;
	}

	sOutBuf[iRPos] = '\0';

	return iRPos;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////

//Returns true if the character passed into cChar is a whitespace, otherwise it returns false.
bool IsWhiteSpace(char cChar)
{
    if(cChar == ' ' || cChar == '\r' || cChar == '\n' || cChar == '\t' || cChar == '\0')
	{
        return true;
	}
    return false;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////

//Returns the position of the first valid character in the string passed into sInBuf.
//iInBufSz should be the length of the string being passed into sInBuf
int GetFirstCharPos(char *sInBuf, int iInBufSz)
{
    for(int iRPos = 0; iRPos < iInBufSz; iRPos++)
    {
        if(!IsWhiteSpace(sInBuf[iRPos]))
		{
            return iRPos;
		}
	}
    return -1;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////

//Returns the position of the last valid character in the string passed into sInBuf.
//iInBufSz should be the length of the string being passed into sInBuf
int GetLastCharPos(char *sInBuf, int iInBufSz)
{
    int iRPos = iInBufSz;
    while(iRPos != 0)
    {
        if(!IsWhiteSpace(sInBuf[iRPos]))
		{
            return iRPos + 1;
		}
		iRPos--;
	}
    return -1;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////

char *FormatiString(char *sOut, const char *sIn)
{
    int RPos = strlen(sIn) - 1;
    int WPos = 0;
    int DPos = 0;

    if(RPos < 3)
    {
        strcpy(sOut, sIn);
        return sOut;
    }

    while(RPos != -1)
    {
        if(DPos++ == 3)
        {
            sOut[WPos++] = ',';
            DPos = 1;
        }

        sOut[WPos++] = sIn[RPos--];
    }

    ReverseString(sOut, WPos);

    sOut[WPos] = '\0';

    return sOut;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

char *FormatInteger(char *sOut, const long lIn)
{
    char sLong[64];
    _ultoa(lIn, sLong, 10);
    return FormatiString(sOut, sLong);
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////
#endif
